/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.applets;

import coldfusion.applets.CFBaseApplet;
import coldfusion.applets.CFGrid;
import coldfusion.applets.CFGridDescription;
import coldfusion.applets.CFGridTableModelAdapter;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

class CFGridListSelectionListener
implements ListSelectionListener {
    private int m_iColSelected = 0;
    private int m_iRowSelected = 0;
    private final CFBaseApplet m_applet;
    private final CFGridDescription m_gridDesc;
    private final CFGrid m_table;
    private final TableModel m_tm;
    private final CFGridTableModelAdapter m_tmSortedOnly;

    CFGridListSelectionListener(CFBaseApplet cFBaseApplet, CFGrid cFGrid, CFGridDescription cFGridDescription, CFGridTableModelAdapter cFGridTableModelAdapter) {
        this.m_applet = cFBaseApplet;
        this.m_gridDesc = cFGridDescription;
        this.m_table = cFGrid;
        this.m_tm = this.m_table.getModel();
        this.m_tmSortedOnly = cFGridTableModelAdapter;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            return;
        }
        boolean bl = this.m_table.getSelectionModel() == listSelectionModel;
        if (bl) {
            this.m_iRowSelected = listSelectionModel.getMinSelectionIndex();
        } else {
            this.m_iColSelected = listSelectionModel.getMinSelectionIndex();
        }
        switch (this.m_gridDesc.getSelectMode()) {
            case 104: {
                listSelectionModel.clearSelection();
                this.m_applet.setBrowserFormParam("");
                return;
            }
            case 101: {
                if (this.m_tm instanceof CFGridTableModelAdapter && (object = (CFGridTableModelAdapter)this.m_tm).getColumnDesc(this.m_iColSelected).columnIsReadOnly()) {
                    listSelectionModel.clearSelection();
                    this.m_applet.setBrowserFormParam("");
                    return;
                }
                if (!bl) break;
                return;
            }
            case 102: {
                if (bl) break;
                return;
            }
            case 103: {
                if (this.m_tm instanceof CFGridTableModelAdapter && (object = (CFGridTableModelAdapter)this.m_tm).getColumnDesc(this.m_iColSelected).columnIsReadOnly()) {
                    listSelectionModel.clearSelection();
                    this.m_applet.setBrowserFormParam("");
                    return;
                }
                if (!bl) break;
                return;
            }
            case 105: {
                return;
            }
        }
        object = null;
        switch (this.m_gridDesc.getSelectMode()) {
            case 101: 
            case 104: {
                object = this.getSingleSelectionData();
                break;
            }
            case 102: {
                object = this.getRowSelectionData();
                break;
            }
            case 103: {
                object = this.getColumnSelectionData();
                break;
            }
        }
        if (object != null) {
            this.m_applet.setBrowserFormParam((String)object);
        }
    }

    private String getSingleSelectionData() {
        Object object;
        String string = null;
        String string2 = "";
        if (this.m_tm instanceof CFGridTableModelAdapter) {
            object = (CFGridTableModelAdapter)this.m_tm;
            string2 = object.getColumnDesc(this.m_iColSelected).getColumnDBName();
        }
        object = this.m_table.getValueAt(this.m_iRowSelected, this.m_iColSelected);
        string = "__CFGRID__COLUMN__=" + string2 + "; __CFGRID__DATA__=" + object.toString();
        return string;
    }

    private String getColumnSelectionData() {
        String string = null;
        String string2 = "";
        if (this.m_tm instanceof CFGridTableModelAdapter) {
            CFGridTableModelAdapter cFGridTableModelAdapter = (CFGridTableModelAdapter)this.m_tm;
            string2 = cFGridTableModelAdapter.getColumnDesc(this.m_iColSelected).getColumnDBName();
        }
        int n = this.m_gridDesc.getRowCount();
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            Object object = this.m_table.getValueAt(i, this.m_iColSelected);
            string3 = string3 == null ? object.toString() : string3 + "," + object.toString();
        }
        string = "__CFGRID__COLUMN__=" + string2 + "; __CFGRID__DATA__=" + string3;
        return string;
    }

    private String getRowSelectionData() {
        Object object = null;
        int n = this.m_tmSortedOnly.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Object object2;
            Object object3 = this.m_tmSortedOnly.getValueAt(this.m_iRowSelected, i);
            String string = "";
            if (this.m_tmSortedOnly instanceof CFGridTableModelAdapter) {
                object2 = this.m_tmSortedOnly;
                string = object2.getColumnDesc(i).getColumnDBName();
            }
            object2 = "__CFGRID__COLUMN__=" + string + "; __CFGRID__DATA__=" + object3.toString();
            object = object == null ? object2 : (String)object + "; " + (String)object2;
        }
        return object;
    }
}

