/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.applets;

import coldfusion.applets.CFGridExprEvalException;
import coldfusion.applets.CFGridExprParseException;
import javax.swing.table.TableModel;

public abstract class CFGridExpr {
    private boolean m_bIsValid = false;
    private int m_iColIndex = -1;
    private int m_iOperator = -1;
    private int m_iDataType = -1;
    private String m_strValue = null;
    private Object m_objTrue = null;
    private Object m_objFalse = null;
    private static final int COL_UNKNOWN = -1;
    private static final int COL_CURRENT = -2;
    private static final int OP_UNKNOWN = -1;
    private static final int OP_EQUALS = 1;
    private static final int OP_LESSTHAN = 2;
    private static final int OP_GREATERTHAN = 3;
    private static final int TYPE_UNKNOWN = -1;
    private static final int TYPE_ALPHABETIC = 1;
    private static final int TYPE_NUMERIC = 2;
    private static final int EX_ID_1 = 1;
    private static final int EX_ID_2 = 2;
    private static final int EX_ID_3 = 3;
    private static final int EX_ID_4 = 4;
    private static final int EX_ID_5 = 5;
    private static final int EX_ID_6 = 6;
    private static final int EX_ID_7 = 7;
    private static final int EX_ID_8 = 8;
    private static final int EX_ID_9 = 9;
    private static final int EX_ID_10 = 10;

    public boolean isValid() {
        return this.m_bIsValid;
    }

    public Object evaluate(TableModel tableModel, int n, int n2) throws CFGridExprEvalException {
        Object object;
        if (!this.m_bIsValid) {
            throw new CFGridExprEvalException(3);
        }
        if (tableModel == null) {
            throw new CFGridExprEvalException(4);
        }
        if (n < 0 || n2 < 0) {
            throw new CFGridExprEvalException(5);
        }
        int n3 = n2;
        if (this.m_iColIndex != -1 && this.m_iColIndex != -2) {
            n3 = this.m_iColIndex;
        }
        if ((object = tableModel.getValueAt(n, n3)) == null) {
            throw new CFGridExprEvalException(6);
        }
        Object object2 = this.evaluate(object.toString());
        if (object2 == null) {
            throw new CFGridExprEvalException(7);
        }
        return object2;
    }

    public void debugDump() {
        System.out.println("Evaluation Object:\n\n m_bIsValid: " + String.valueOf(this.m_bIsValid) + "\n m_iColIndex: " + String.valueOf(this.m_iColIndex) + "\n m_iOperator: " + String.valueOf(this.m_iOperator) + "\n m_iDataType: " + String.valueOf(this.m_iDataType) + "\n m_strValue: " + (this.m_strValue == null ? "NULL" : this.m_strValue.toString()) + "\n m_objTrue: " + (this.m_objTrue == null ? "NULL" : this.m_objTrue.toString()) + "\n m_objFalse: " + (this.m_objFalse == null ? "NULL" : this.m_objFalse.toString()) + "\n");
    }

    protected CFGridExpr(String string) {
        try {
            this.parse(string);
            this.m_bIsValid = true;
        }
        catch (CFGridExprParseException cFGridExprParseException) {
            // empty catch block
        }
    }

    protected abstract Object parseResultObject(String var1) throws CFGridExprParseException;

    protected int parseColumnNumber(String string) throws CFGridExprParseException {
        int n = -1;
        if ((string = string.trim().toUpperCase()).length() < 2 || string.charAt(0) != 'C') {
            throw new CFGridExprParseException(6);
        }
        if (string.charAt(1) == 'X') {
            n = -2;
        } else {
            try {
                n = Integer.parseInt(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new CFGridExprParseException(7);
            }
        }
        return n;
    }

    protected int parseOperator(String string) throws CFGridExprParseException {
        if ((string = string.trim().toUpperCase()).length() < 2) {
            throw new CFGridExprParseException(9);
        }
        if (string.equals("EQ")) {
            return 1;
        }
        if (string.equals("LT")) {
            return 2;
        }
        if (string.equals("GT")) {
            return 3;
        }
        throw new CFGridExprParseException(8);
    }

    protected String parseValue(String string) throws CFGridExprParseException {
        if ((string = string.trim()).length() == 0) {
            throw new CFGridExprParseException(10);
        }
        return string;
    }

    protected Object evaluate(String string) throws CFGridExprEvalException {
        if (this.m_iDataType == -1) {
            try {
                Integer.parseInt(this.m_strValue);
                this.m_iDataType = 2;
            }
            catch (NumberFormatException numberFormatException) {
                this.m_iDataType = 1;
            }
        }
        string = string.trim();
        if (this.m_iDataType == 2) {
            int n;
            int n2;
            try {
                n2 = Integer.parseInt(string);
                n = Integer.parseInt(this.m_strValue);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CFGridExprEvalException(1);
            }
            switch (this.m_iOperator) {
                case 1: {
                    return n2 == n ? this.m_objTrue : this.m_objFalse;
                }
                case 2: {
                    return n2 < n ? this.m_objTrue : this.m_objFalse;
                }
                case 3: {
                    return n2 > n ? this.m_objTrue : this.m_objFalse;
                }
            }
        } else {
            int n = this.m_strValue.compareTo(string);
            switch (this.m_iOperator) {
                case 1: {
                    return n == 0 ? this.m_objTrue : this.m_objFalse;
                }
                case 2: {
                    return n < 0 ? this.m_objTrue : this.m_objFalse;
                }
                case 3: {
                    return n > 0 ? this.m_objTrue : this.m_objFalse;
                }
            }
        }
        throw new CFGridExprEvalException(2);
    }

    private void parse(String string) throws CFGridExprParseException {
        int n = string.indexOf(40, 0);
        if (n == -1) {
            throw new CFGridExprParseException(1);
        }
        int n2 = string.indexOf("EQ", n + 1);
        if (n2 == -1 && (n2 = string.indexOf("LT", n + 1)) == -1 && (n2 = string.indexOf("GT", n + 1)) == -1) {
            throw new CFGridExprParseException(2);
        }
        int n3 = string.indexOf(63, n2 + 2);
        if (n3 == -1) {
            throw new CFGridExprParseException(3);
        }
        int n4 = string.indexOf(58, n3 + 1);
        if (n4 == -1) {
            throw new CFGridExprParseException(4);
        }
        int n5 = string.indexOf(41, n4 + 1);
        if (n5 == -1) {
            throw new CFGridExprParseException(5);
        }
        this.m_iColIndex = this.parseColumnNumber(string.substring(n + 1, n2));
        this.m_iOperator = this.parseOperator(string.substring(n2, n2 + 2));
        this.m_strValue = this.parseValue(string.substring(n2 + 2, n3));
        this.m_objTrue = this.parseResultObject(string.substring(n3 + 1, n4));
        this.m_objFalse = this.parseResultObject(string.substring(n4 + 1, n5));
    }
}

